import 'package:rad/rad.dart';

import 'package:photogram_admin_cp/import/core.dart';

import 'package:photogram_admin_cp/ui/pages/common/form_editor_page.dart';

class GeneralSiteSettingsSection extends StatefulWidget {
  const GeneralSiteSettingsSection({Key? key}) : super(key: key);

  @override
  _GeneralSiteSettingsSectionState createState() => _GeneralSiteSettingsSectionState();
}

class _GeneralSiteSettingsSectionState extends State<GeneralSiteSettingsSection> with AppActiveContentMixin {
  @override
  build(context) {
    return FormEditorPage(
      heading: 'General Site Settings',
      description: 'Settings related to your site.',
      items: [
        SettingItem(
          intId: AppSettings.ID_SS_TEXT_NAME,
          settingKey: AppSettings.KEY_SS_TEXT_NAME,
          type: FieldType.text,
          leading: 'Site Name',
          placeholder: 'name',
          description: 'Name of the site. Please note that this will be reflected only on API endpoint.',
        ),
        SettingItem(
          intId: AppSettings.ID_SS_TEXT_MAILER_CONTACT_EMAIL,
          settingKey: AppSettings.KEY_SS_TEXT_MAILER_CONTACT_EMAIL,
          type: FieldType.text,
          leading: 'Contact Email Address',
          placeholder: 'Email Address',
          description: 'Email address that your users can use to reach you.',
        ),
        SettingItem(
          intId: AppSettings.ID_SS_TEXT_MAILER_NO_REPLY_EMAIL,
          settingKey: AppSettings.KEY_SS_TEXT_MAILER_NO_REPLY_EMAIL,
          type: FieldType.text,
          leading: 'No-Reply Email Address',
          placeholder: 'Email Address',
          description: "Email address that'll be used for sending system emails to your users.",
        ),
      ],
    );
  }
}
